<?php

require_once '../../../init.php';
require_once '../../../includes/gatewayfunctions.php';
require_once '../../../includes/invoicefunctions.php';

header('Content-Type: application/json');

$input = file_get_contents('php://input');

$input = json_decode($input);

$user_key = $gatewayParams['apiKey'];

$password = $gatewayParams['apiSecret'];

$identifier = $input->paymentToken->transactionIdentifier;

$order_id = "whmcs_applepay_" . rand(1000, 9999);

$order_amount = $input->user->amount;

$order_currency = "SAR";

$name = explode(' ', $input->user->name);

function calculateHash($identifier, $order_id, $order_amount, $order_currency, $password) {
    // Concatenate values
    $concatenatedString = $identifier . $order_id . $order_amount . $order_currency . $password;

    // Reverse the concatenated string
    $reversedString = strrev($concatenatedString);

    // Convert the reversed string to uppercase
    $upperCaseString = strtoupper($reversedString);

    // Calculate the MD5 hash
    $finalHash = md5($upperCaseString);

    return $finalHash;
}

$hash = calculateHash($identifier, $order_id, $order_amount, $order_currency, $password);

// cURL request
$url = 'https://api.edfapay.com/applepay/orders/s2s/sale';

$fields = [
    'action' => 'SALE',
    'client_key' => $user_key,
    'brand' => 'applepay',
    'order_id' => $order_id,
    'order_amount' => $order_amount,
    'order_currency' => $order_currency,
    'order_description' => 'donate #' . $order_id,
    'payer_first_name' => $name[0],
    'payer_last_name' => $name[1] ?? 'Mohamed',
    'payer_address' => 'Riyadh',
    'payer_country' => 'SA',
    'payer_state' => 'Riyadh',
    'payer_city' => 'Riyadh',
    'payer_zip' => rand(10000, 99999),
    'payer_email' => $input->user->email,
    'payer_phone' => $input->user->phone,
    'payer_birth_date' => '1988-03-20',
    'payer_ip' => '105.38.142.20',
    'return_url' => 'https://www.royat.sa',
    'hash' => $hash,
    'identifier' => $identifier,
    'parameters' => json_encode($input->paymentToken) // JSON-encode the payment token
];

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $fields,
]);

$response = curl_exec($curl);

if ($response === false) {
    $error = curl_error($curl);
    curl_close($curl);
    die("cURL error: $error");
}

curl_close($curl);

$js = json_decode($response);

if($js->status == 'SETTLED'){
  addInvoicePayment($input->user->invoice_id,$js->trans_id, $input->user->amount, 0, $gatewayModuleName);
  echo $response;
}

?>