<?php

require_once '../../../init.php';
require_once '../../../includes/gatewayfunctions.php';
require_once '../../../includes/invoicefunctions.php';

header('Content-Type: application/json');

$input = file_get_contents('php://input');

$domain_name = $_SERVER["HTTP_HOST"];
$validation_url = json_decode($input, true);

$data = json_encode(array(
    "merchantIdentifier" => $gatewayParams['appleIdentifier'],
    "domainName" => $domain_name,
    "displayName" => 'Pay'
));

define('PEM_FILE', 'merchant_id.pem');
define('KEY_FILE', 'merchant.key');

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $validation_url['validationUrl']);
curl_setopt($ch, CURLOPT_SSLCERT, PEM_FILE);
curl_setopt($ch, CURLOPT_SSLKEY, KEY_FILE);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the response as a string
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Disable SSL verification (not recommended for production)

$response = curl_exec($ch);

if ($response === false) {
    $error = curl_error($ch);
    echo json_encode(array("curlError" => $error));
} else {
    echo $response;
}

curl_close($ch);

?>