<?php
session_start();
ob_start();


require_once '../../../init.php';
require_once '../../../includes/gatewayfunctions.php';
require_once '../../../includes/invoicefunctions.php';

// Define gateway module name
$gatewayModuleName = 'royatpay';

// Fetch gateway configuration parameters
$gatewayParams = getGatewayVariables($gatewayModuleName);

if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

if(isset($_POST['invoice_id']) && isset($_POST['cardnumber'])){
  
    unset($_SESSION['royatpay_trans_id'],$_SESSION['royatpay_invoice_id'],$_SESSION['royatpay_card_number']); 
  
    // Get the card details and invoice info
    $invoiceId = $_POST['invoice_id'];
    $cardNumber = $_POST['cardnumber'];
    $expiryDate = $_POST['expirydate'];
    $cvv = $_POST['cvv'];
    $amount = $_POST['amount'];
    $currency = $_POST['currency'];

    // Prepare the data to send to RoyatPay
    $data = array(
        'api_key' => $gatewayParams['apiKey'],
        'invoice_id' => $invoiceId,
        'amount' => $amount,
        'currency' => $currency,
        'card_number' => $cardNumber,
        'expiryMonth' => explode('/', $expiryDate)[0],
        'expiryYear' => '20' . explode('/', $expiryDate)[1],
        'cvv' => $cvv,
    );

    $orderID = 'royatwhmcs-1' . $invoiceId .  rand(100000, 999999);

    $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://api.royat.sa/api/payments/create',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode([
        'order' => [
            'id' => $orderID,
            'amount' => $amount,
            'description' => 'order royat whmcs #' . $invoiceId
        ],
        'customer' => [
            'name' => $_POST['name'],
            'email' => $_POST['email'],
            'phone' => $_POST['phone'],
            'city' => 'riyadh',
            'address' => 'riyadh',
            'zip' => rand(10000, 99999),
            'ip' => '105.38.142.20',
            'redirect' => $gatewayParams['systemurl'] . 'modules/gateways/royatpay/royatpay_callback.php'
        ],
        'card' => [
            'number' => $_POST['cardnumber'],
            'ex_month' => $data['expiryMonth'],
            'ex_year' => $data['expiryYear'],
            'cvv' => $_POST['cvv']
        ],
        'user' => [
            'key' => $gatewayParams['apiKey'],
            'password' => $gatewayParams['apiSecret'],
        ]
    ]),
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Content-Type: application/json'
        ],
    ));

    $response = curl_exec($curl);

    curl_close($curl);
  

    // Handle RoyatPay response
    $responseData = json_decode($response, true);
    if ($responseData['result'] == 'success') {
        // Payment was successful
        addInvoicePayment($invoiceId, $responseData['transaction_id'], $amount, 0, $gatewayModuleName);
        logTransaction($gatewayParams['name'], $responseData, 'Successful');
        // Redirect to invoice paid page
        header("Location: " . $gatewayParams['systemurl'] . "viewinvoice.php?id=" . $invoiceId . "&paymentsuccess=true");

    }elseif($responseData['result'] == 'redirect'){
        $_SESSION['royatpay_trans_id'] = $responseData['trans_id'];
        $_SESSION['royatpay_order_id'] = $orderID;
        $_SESSION['royatpay_card_number'] = $_POST['cardnumber'];
        $_SESSION['royatpay_email'] = $_POST['email'];
        $_SESSION['royatpay_amount'] = $_POST['amount'];
        $_SESSION['royatpay_invoice_id'] = $_POST['invoice_id'];
        header('Location: ' . $responseData['url']);
    }else {
        // Payment failed
        logTransaction($gatewayParams['name'], $responseData, 'Unsuccessful');
        // Redirect to invoice with error message
        header("Location: " . $gatewayParams['systemurl'] . "viewinvoice.php?id=" . $invoiceId . "&paymentfailed=true");
    }
    exit();
  
//if we want verify the payment
}elseif(isset($_SESSION['royatpay_trans_id']) && isset($_SESSION['royatpay_invoice_id']) && isset($_SESSION['royatpay_card_number'])) {

      function generateHash($email, $password, $trans_id, $card_number) {
        // Reverse the email
        $reversed_email = strrev($email);
        // Get the first 6 characters of card_number
        $first_part = substr($card_number, 0, 6);
        // Get the last 4 characters of card_number
        $last_part = substr($card_number, -4);
        // Concatenate and reverse the result
        $reversed_card_part = strrev($first_part . $last_part);
        // Concatenate reversed email, PASSWORD, trans_id, and reversed card part
        $concatenated_string = $reversed_email . $password . $trans_id . $reversed_card_part;
        // Convert the concatenated string to uppercase
        $uppercase_string = strtoupper($concatenated_string);
        // Generate MD5 hash
        $hash = md5($uppercase_string);
        
        return $hash;
    }

    // Set the necessary variables
    $merchant_id = $gatewayParams['apiKey']; // Replace with your merchant ID
    $password = $gatewayParams['apiSecret']; // Replace with your password
    $trans_id = $_SESSION['royatpay_trans_id']; // Replace with the transaction ID from the session
    $email = $_SESSION['royatpay_email'];
    $card_number = $_SESSION['royatpay_card_number'];

    // Prepare the data for the POST request
    $post_data = array(
        'action' => 'GET_TRANS_STATUS',
        'client_key' => $merchant_id,
        'trans_id' => $trans_id,
        'hash' => generateHash($email, $password, $trans_id, $card_number)
    );

    // Initialize cURL
    $ch = curl_init();

    // Set the cURL options
    curl_setopt($ch, CURLOPT_URL, "https://api.edfapay.com/payment/post");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/x-www-form-urlencoded'
    ));

    // Execute the cURL request
    $response = curl_exec($ch);

    // Check for errors
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
        curl_close($ch);
        return;
    }

    // Close cURL
    curl_close($ch);

    // Decode the response
    $body = json_decode($response, true);
  
    if ($body['status'] !== 'DECLINED') {
        // Payment was successful
        addInvoicePayment($_SESSION['royatpay_invoice_id'],$_SESSION['royatpay_trans_id'], $_SESSION['amount'], 0, $gatewayModuleName);
        logTransaction($gatewayParams['name'], $body, 'Successful');
        // Redirect to invoice paid page
        header("Location: " . $gatewayParams['systemurl'] . "viewinvoice.php?id=" . $_SESSION['royatpay_invoice_id'] . "&paymentsuccess=true");
    } else {
        // Payment was not successful    
        logTransaction($gatewayParams['name'], $body, 'Failed');
        header("Location: " . $gatewayParams['systemurl'] . "viewinvoice.php?id=" . $_SESSION['royatpay_invoice_id'] . "&paymentfailed=true");
    }
 
  exit();
  
}else{
  echo 'something wrong';
}