console.log(royatVars);
if (window.ApplePaySession) {
	var merchantIdentifier = royatVars.apple_merchant_identifier;
	var promise = ApplePaySession.canMakePaymentsWithActiveCard(merchantIdentifier);
	promise.then(function (canMakePayments) {
	   if (canMakePayments) {
		  document.getElementById("applePay").style.display = "block";
	   } else {   
		  document.getElementById("got_notactive").style.display = "block";
	   }
	 }); 
} else {
	 document.getElementById("notgot").style.display = "block";
}
 
document.getElementById("applePay").onclick = () => {

	//get the user information from woorcomerce and pass it to apple pay
	let royatAppleUser = {
		name : document.querySelector('input[name="name"]').value,
        email : document.querySelector('input[name="email"]').value,
        phone : document.querySelector('input[name="phone"]').value,        
        invoice_id : document.querySelector('input[name="invoiceid"]').value,
        amount : document.querySelector('input[name="amount"]').value
	};
	
    let hasEmptyField = Object.values(royatAppleUser).some(value => value.trim() === '');

    if (hasEmptyField) {
        alert('Please fill in all required fields.');
        return; // Stop execution if any field is empty
    }

  var paymentRequest = {
	 "currencyCode": "SAR",
	 "countryCode": "SA",
 
	 "total": {
		 "label": "Pay",
		 "amount": royatVars.amount
	 },
	 "supportedNetworks": ["amex", "masterCard", "visa","mada"],
	 "merchantCapabilities": ["supports3DS"]
 };

 var session = new ApplePaySession(1, paymentRequest);

 session.onvalidatemerchant = (event) => {
    fetch(royatVars.siteUrl + 'modules/gateways/royatpay/validate_url.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ validationUrl: event.validationURL })
    })
    .then(response => response.json())
    .then(merchantSession => {
      session.completeMerchantValidation(merchantSession);
    })
    .catch(error => {
      console.error('Merchant validation failed:', error);
      session.abort();
    });
  };


  function sendPaymentToken(paymentToken) {

    return fetch(royatVars.siteUrl + 'modules/gateways/royatpay/virtual.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ 
            paymentToken: paymentToken,
            user : royatAppleUser
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        return data; // Handle response data if necessary
    })
    .catch(error => {
        console.error('Error sending payment token:', error);
        throw error;
    });
}

session.onpaymentauthorized = function (event) {

	var promise = sendPaymentToken(event.payment.token);
	promise.then(function (success) {	
		var status;
		if (success){
			status = ApplePaySession.STATUS_SUCCESS;
		} else {
			status = ApplePaySession.STATUS_FAILURE;
		}		

		session.completePayment(status);

		if(success){
			//refresh the page
            window.location.reload();
		}


	});
}
	session.begin();

}