<?php
$wordpress_path = '../../../wp-load.php'; // Adjusted to 3 levels up

if (file_exists($wordpress_path)) {
    require_once($wordpress_path);

    // WooCommerce specific function to ensure WooCommerce is loaded
    if (class_exists('WC_Gateway_RoyatPay')) {
        // Instantiate the WC_Gateway_RoyatPay class
        $class = new WC_Gateway_RoyatPay();

        header('Content-Type: application/json');

        $input = file_get_contents('php://input');

        $domain_name = $_SERVER["HTTP_HOST"];

        $validation_url = json_decode($input, true);

        $data = json_encode(array(
            "merchantIdentifier" => $class->get_option('apple_merchant_identifier'),
            "domainName" => $domain_name,
            "displayName" => 'Pay'
        ));

        define('PEM_FILE', 'cer/royatpay-pem_file.pem');
        define('KEY_FILE', 'cer/royatpay-key_file.key');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $validation_url['validationUrl']);
        curl_setopt($ch, CURLOPT_SSLCERT, PEM_FILE);
        curl_setopt($ch, CURLOPT_SSLKEY, KEY_FILE);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the response as a string
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Disable SSL verification (not recommended for production)

        $response = curl_exec($ch);

        if ($response === false) {
            $error = curl_error($ch);
            echo json_encode(array("curlError" => $error));
        } else {
            echo $response;
        }

        curl_close($ch);

    } else {
        die('WooCommerce is not active.');
    }
} else {
    die('WordPress environment not found. Ensure wp-load.php is in the correct location.');
}

?>